
const flagDiv = document.createElement('div');
flagDiv.id = 'DPL-extension-loaded-flag';
flagDiv.style.display = 'none';
flagDiv.style.visibility = 'hidden';
flagDiv.setAttribute('data-version', chrome.runtime.getManifest().version);

// Append to body immediately if available (most likely will be available due to run_at: "document_idle").
if (document.body) {
    document.body.appendChild(flagDiv);
} else {
    // Fallback: Use MutationObserver to wait for the <body> element to be ready.
    new MutationObserver((mutationsList, observer) => {
        if (document.body) {
            document.body.appendChild(flagDiv);
            observer.disconnect();
        }
    }).observe(document.documentElement, { childList: true, subtree: true });
}

window.addEventListener('message', (event) => {
    // Check message origin to ensure it's from your app
    if (event.source !== window) {
        return;
    }

    // --- Existing Email Logic ---
    if (event.data.action === 'sendImageEmail') {
        console.log("in content.js, begin send message");
        try {
            chrome.runtime.sendMessage({
                action: "openGmailWithImage",
                subject: event.data.subject,
                body: event.data.body,
                imageData: event.data.imageData
            });
        } catch (e) {
            // Handle the context invalidation gracefully
            console.error("Failed to send message to background script for email:", e.message);
        }
        return;
    }

    // --- NEW Download Logic ---
    if (event.data.action === 'downloadImage' && event.data.imageData) {
        console.log("in content.js, begin download message");
        try {
            chrome.runtime.sendMessage({
                action: "startImageDownload", // New action for background script
                imageData: event.data.imageData,
                filename: event.data.filename || "downloaded_image.png" // Use a default if filename isn't provided
            });
        } catch (e) {
            console.error("Failed to send message to background script for download:", e.message);
        }
    }
});